package user_interface;
import db_context.MyExceptions;
import row_data_gateway.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class MenuDriver extends Menu {
    @Override
    public void print() {
        System.out.println("***********************************");
        System.out.println("* 1. print driver                 *");
        System.out.println("* 2. create driver                *");
        System.out.println("* 3. update driver                *");
        System.out.println("* 4. delete driver                *");
        System.out.println("* 5. back to main menu            *");
        System.out.println("***********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":  printDriver(); break;
                case "2":  createDriver(); break;
                case "3":  updateDriver(); break;
                case "4":  deleteDriver(); break;
                case "5":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        }catch(Exception e) {
            //throw new RuntimeException(e);
            if(e.getClass().toString().equals("class java.lang.NumberFormatException")) System.out.println("Wrong input");
            else System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }

    private void printDriver() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter driver id");

        Driver driver = DriverFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        DriverFinder.getInstance().printDriver(driver);
    }

    private void createDriver() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Driver driver = new Driver();

        System.out.println("Enter driver name:");
        driver.setFirst_name(br.readLine());
        System.out.println("Enter driver surname:");
        driver.setSecond_name(br.readLine());

        System.out.println("Enter driver location:");
        int var = Integer.parseInt(br.readLine());
        if(var < 1 || var > 49) throw new MyExceptions.NotSuchIdException("Not such location");
        driver.setLocation_id(var);

        driver.insert();
        System.out.println("driver has been added, id: " + driver.getId());
    }

    private void updateDriver() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter a driver id:");

        Driver driver = DriverFinder.getInstance().findById(Integer.parseInt(br.readLine()));

        System.out.println("Enter what to update:\n");
        System.out.println("* 1. name                         *");
        System.out.println("* 2. surname                      *");
        System.out.println("* 3. salary                       *");
        System.out.println("* 4. location                     *\n");

        switch (br.readLine()) {
            case "1":
                System.out.println("Enter new name");
                driver.setFirst_name(br.readLine()); break;
            case "2":
                System.out.println("Enter new surname");
                driver.setSecond_name(br.readLine()); break;
            case "3":
                System.out.println("Enter new salary");
                try { driver.setSalary(new BigDecimal(br.readLine())); }
                catch(Exception e){ throw new java.lang.NumberFormatException("Wrong input"); }
                break;
            case "4":
                System.out.println("Enter new location");
                int var = Integer.parseInt(br.readLine());
                if(var < 1 || var > 49) throw new MyExceptions.NotSuchIdException("Not such location");
                driver.setLocation_id(var); break;
            default:    System.out.println("Unknown option"); return;
        }
        driver.update();
        System.out.println("driver has been updated");
    }

    private void deleteDriver() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter a driver id:");

        Driver driver = DriverFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        driver.delete();
        System.out.println("driver with id: " + driver.getId() + " has been deleted");
    }
}
